/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.gunfireoverhaul;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.item.IGun;
import com.vinlanx.gunfireoverhaul.ServerGunfireHandler;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gunfireoverhaul")
public class TacZIntegrationHandler {
    @SubscribeEvent
    public static void onGunFire(GunFireEvent event) {
        if (event.getLogicalSide() != LogicalSide.SERVER) {
            return;
        }
        LivingEntity shooter = event.getShooter();
        ItemStack gunStack = event.getGunItemStack();
        ResourceLocation ammoId = TacZIntegrationHandler.getAmmoId(gunStack);
        if (ammoId == null) {
            return;
        }
        String caliberId = ammoId.m_135815_();
        ServerGunfireHandler.handleGunfireEvent(shooter.m_9236_(), shooter, shooter.m_20182_(), caliberId);
    }

    private static ResourceLocation getAmmoId(ItemStack gunStack) {
        Item item = gunStack.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            ResourceLocation gunId = iGun.getGunId(gunStack);
            Optional gunIndex = TimelessAPI.getCommonGunIndex((ResourceLocation)gunId);
            return gunIndex.map(index -> index.getGunData().getAmmoId()).orElse(null);
        }
        return null;
    }
}

